/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.PHPVersionProvider;
import com.aptana.editor.php.core.ast.ASTFactory;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.indexer.ASTVisitorRegistry;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IIndexReporter;
import com.aptana.editor.php.indexer.IIndexingASTVisitor;
import com.aptana.editor.php.indexer.IModuleIndexer;
import com.aptana.editor.php.indexer.IProgramIndexer;
import com.aptana.editor.php.internal.builder.ProjectBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPathReference;
import com.aptana.editor.php.internal.indexer.CallPath;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.CommentsVisitor;
import com.aptana.editor.php.internal.indexer.ElementsIndexingUtils;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPathReference;
import com.aptana.editor.php.internal.indexer.IPHPFunctionEntryValue;
import com.aptana.editor.php.internal.indexer.IncludePHPEntryValue;
import com.aptana.editor.php.internal.indexer.LambdaFunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.NamespacePHPEntryValue;
import com.aptana.editor.php.internal.indexer.PHPDocUtils;
import com.aptana.editor.php.internal.indexer.StaticPathReference;
import com.aptana.editor.php.internal.indexer.TaskTagsUpdater;
import com.aptana.editor.php.internal.indexer.TraitPHPEntryValue;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.indexer.VariablePathReference;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import com.aptana.editor.php.internal.parser.phpdoc.FunctionDocumentation;
import com.aptana.editor.php.internal.parser.phpdoc.TypedDescription;
import com.aptana.editor.php.util.EncodingUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java_cup.runtime.Symbol;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org2.eclipse.php.core.compiler.PHPFlags;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ASTParser;
import org2.eclipse.php.internal.core.ast.nodes.Assignment;
import org2.eclipse.php.internal.core.ast.nodes.Block;
import org2.eclipse.php.internal.core.ast.nodes.CatchClause;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org2.eclipse.php.internal.core.ast.nodes.ClassName;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Dispatch;
import org2.eclipse.php.internal.core.ast.nodes.DoStatement;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org2.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org2.eclipse.php.internal.core.ast.nodes.ForStatement;
import org2.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org2.eclipse.php.internal.core.ast.nodes.FunctionName;
import org2.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.IfStatement;
import org2.eclipse.php.internal.core.ast.nodes.Include;
import org2.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org2.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.Quote;
import org2.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org2.eclipse.php.internal.core.ast.nodes.Scalar;
import org2.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org2.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org2.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org2.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org2.eclipse.php.internal.core.ast.nodes.TryStatement;
import org2.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org2.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org2.eclipse.php.internal.core.ast.nodes.Variable;
import org2.eclipse.php.internal.core.ast.nodes.VariableBase;
import org2.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org2.eclipse.php.internal.core.ast.scanner.AstLexer;
import org2.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;
import org2.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org2.eclipse.php.internal.core.compiler.ast.nodes.VarComment;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDoc;

public class PDTPHPModuleIndexer
implements IModuleIndexer,
IProgramIndexer {
    private static final String DOLLAR_SIGN = "$";
    private static final String EMPTY_STRING = "";
    private static final TaskTagsUpdater updater = new TaskTagsUpdater();
    private static final String THIS = "this";
    private static final String SELF = "self";
    private static final String DEFINE = "define";
    private boolean globalMode = true;
    private int currentOffset = 0;
    private String _contents;
    private List<Comment> _comments;
    private Set<String> _overallGlobalImports = new HashSet<String>();
    private Map<String, String> _overallAliases = new HashMap<String, String>();
    private boolean isReportedStackGlobal = true;
    private boolean isReportedScopeUnderClass = false;
    private boolean updateTaskTags = true;
    private String _namespace;
    private Map<ASTNode, List<VarComment>> _resolvedVarComments;

    public boolean isUpdateTaskTags() {
        return this.updateTaskTags;
    }

    public void setUpdateTaskTags(boolean updateTaskTags) {
        this.updateTaskTags = updateTaskTags;
    }

    public PDTPHPModuleIndexer() {
    }

    public PDTPHPModuleIndexer(boolean globalMode, int currentOffset) {
        this.globalMode = globalMode;
        this.currentOffset = currentOffset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void indexModule(String contents, IModule module, IIndexReporter reporter) {
        Program program;
        block29: {
            this._contents = contents;
            try {
                if (!this.globalMode) {
                    StringBuffer cutContents = new StringBuffer();
                    String prevLine = EMPTY_STRING;
                    int lineStartPos = 0;
                    while (true) {
                        String currentLine;
                        if ((currentLine = this.readLine(contents, lineStartPos)) == null) {
                            cutContents.append("\r\n;");
                            program = this.parse(cutContents.toString(), module);
                            break block29;
                        }
                        int lineEndPos = lineStartPos + currentLine.length();
                        if (this.currentOffset > lineEndPos || this.currentOffset < lineStartPos) {
                            cutContents.append(currentLine);
                        } else {
                            Object text;
                            StringBuilder bld = new StringBuilder();
                            HashSet<Object> variables = new HashSet<Object>();
                            bld.append("<? ");
                            if (currentLine.indexOf(123) != -1) {
                                bld.append(prevLine);
                            }
                            bld.append(currentLine);
                            bld.append(" ?>");
                            StringReader reader = new StringReader(bld.toString());
                            AstLexer lexer = ASTFactory.getAstLexer((PHPVersion)PHPVersion.getLatest(), (Reader)reader);
                            Symbol prev = null;
                            try {
                                while (true) {
                                    Symbol symbol = lexer.next_token();
                                    if (symbol.sym == 82 && prev != null && prev.sym == 8) {
                                        text = (String)prev.value;
                                        variables.add(text);
                                    }
                                    if (symbol.sym != 0) {
                                        prev = symbol;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (IOException iOException) {
                                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP Module Indexer - I/O Error while indexing (indexModule)", (Throwable)iOException, (String)"com.aptana.editor.php/debug/indexer");
                            }
                            text = variables.iterator();
                            while (true) {
                                if (!text.hasNext()) break;
                                String string = (String)text.next();
                                VariablePHPEntryValue value = new VariablePHPEntryValue(0, false, false, false, Collections.<Object>emptySet(), lineStartPos, this._namespace);
                                reporter.reportEntry(3, string.substring(1), value, module);
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            int i = 0;
                            while (true) {
                                if (i >= currentLine.length()) {
                                    cutContents.append(stringBuffer);
                                    break;
                                }
                                char ch = currentLine.charAt(i);
                                if (Character.isWhitespace(ch)) {
                                    stringBuffer.append(ch);
                                } else if (ch == '{' || ch == '}') {
                                    stringBuffer.append(ch);
                                } else {
                                    stringBuffer.append(' ');
                                }
                                ++i;
                            }
                        }
                        prevLine = currentLine;
                        lineStartPos += currentLine.length();
                    }
                }
                program = this.parse(contents, module);
                if (program == null) {
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    return;
                }
                catch (Throwable th) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)("Error while indexing module - " + module.toString()), (Throwable)th);
                    return;
                }
            }
        }
        if (program == null) {
            return;
        }
        CommentsVisitor commentsVisitor = new CommentsVisitor(true);
        program.accept((Visitor)commentsVisitor);
        this._comments = commentsVisitor.getComments();
        this._resolvedVarComments = commentsVisitor.getResolvedVarComments();
        try {
            if (this.isUpdateTaskTags()) {
                updater.updateTaskTags(this._contents, program, this._comments, module);
            }
        }
        catch (Throwable th) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error while updating the task tags", (Throwable)th, (String)"com.aptana.editor.php/debug");
        }
        PHPASTVisitor visitor = new PHPASTVisitor(reporter, module);
        program.accept((Visitor)visitor);
        IIndexingASTVisitor[] iIndexingASTVisitorArray = ASTVisitorRegistry.getInstance().getVisitors();
        int n = iIndexingASTVisitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexingASTVisitor v = iIndexingASTVisitorArray[n2];
            v.process(program, reporter, module);
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void indexModule(IModule module, IIndexReporter reporter) {
        Program program;
        try {
            this.setContents(module, null);
            program = this.parse(this._contents, module);
            if (program == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                return;
            }
            catch (Throwable th) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)("Error while indexing module - " + module.toString()), (Throwable)th);
                return;
            }
        }
        if (program == null) {
            return;
        }
        CommentsVisitor commentsVisitor = new CommentsVisitor();
        program.accept((Visitor)commentsVisitor);
        this._comments = commentsVisitor.getComments();
        try {
            if (this.isUpdateTaskTags()) {
                updater.updateTaskTags(this._contents, program, this._comments, module);
            }
        }
        catch (Throwable th) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error while updating the task tags", (Throwable)th, (String)"com.aptana.editor.php/debug");
        }
        PHPASTVisitor visitor = new PHPASTVisitor(reporter, module);
        program.accept((Visitor)visitor);
        IIndexingASTVisitor[] iIndexingASTVisitorArray = ASTVisitorRegistry.getInstance().getVisitors();
        int n = iIndexingASTVisitorArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                program.getAST().flushErrors();
                return;
            }
            IIndexingASTVisitor v = iIndexingASTVisitorArray[n2];
            v.process(program, reporter, module);
            ++n2;
        }
    }

    private void setContents(IModule module, String source) throws IOException {
        String currentLine;
        BufferedReader reader = source == null ? new BufferedReader(new InputStreamReader(module.getContents(), EncodingUtils.getModuleEncoding(module))) : new BufferedReader(new InputStreamReader((InputStream)new StringInputStream(source), EncodingUtils.getModuleEncoding(module)));
        StringBuffer moduleData = new StringBuffer();
        try {
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                moduleData.append(readData);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a BufferedReader in the PDTPHPModuleIndexer", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                }
            }
        }
        String contents = moduleData.toString();
        StringBuffer cutContents = new StringBuffer();
        int lineStartPos = 0;
        while ((currentLine = this.readLine(contents, lineStartPos)) != null) {
            int lineEndPos = lineStartPos + currentLine.length();
            if (this.globalMode || this.currentOffset > lineEndPos || this.currentOffset < lineStartPos) {
                cutContents.append(currentLine);
            } else {
                StringBuffer replaceBuffer = new StringBuffer();
                int i = 0;
                while (i < currentLine.length()) {
                    char ch = currentLine.charAt(i);
                    if (ch == '\r' || ch == '\n') {
                        replaceBuffer.append(ch);
                    } else {
                        replaceBuffer.append(' ');
                    }
                    ++i;
                }
                cutContents.append(replaceBuffer);
            }
            lineStartPos += currentLine.length();
        }
        this._contents = cutContents.toString();
    }

    public Set<String> getGlobalImports() {
        return this._overallGlobalImports;
    }

    public boolean isReportedScopeGlobal() {
        return this.isReportedStackGlobal;
    }

    public boolean isReportedScopeUnderClass() {
        return this.isReportedScopeUnderClass;
    }

    private String readLine(String contents, int lineStartPos) {
        StringBuffer result = new StringBuffer();
        int i = lineStartPos;
        while (i < contents.length()) {
            if (i == contents.length() - 1) {
                result.append(contents.substring(lineStartPos, contents.length()));
                break;
            }
            char ch = contents.charAt(i);
            switch (ch) {
                case '\r': {
                    if (i < contents.length() - 1 && contents.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    result.append(contents.substring(lineStartPos, i + 1));
                    return result.toString();
                }
            }
            ++i;
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    private Program parse(String contents, IModule module) {
        try {
            PHPVersion phpVersion;
            StringReader reader = new StringReader(contents);
            IProject project = null;
            if (module.getBuildPath() instanceof ProjectBuildPath) {
                project = ((ProjectBuildPath)module.getBuildPath()).getProject();
            }
            PHPVersion version = (phpVersion = PHPVersionProvider.getPHPVersion(project)) == null ? PHPVersionProvider.getDefaultPHPVersion() : phpVersion;
            ASTParser parser = ASTParser.newParser((Reader)reader, (PHPVersion)version, (boolean)true, (ISourceModule)ModelUtils.convertModule(module));
            return parser.createAST(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String typeToString(int intType) {
        switch (intType) {
            case 0: {
                return "_integer";
            }
            case 1: {
                return "_real";
            }
            case 2: {
                return "_string";
            }
            case 4: {
                return "_system";
            }
            case 3: {
                return "_unknown";
            }
        }
        return null;
    }

    @Override
    public void indexModule(Program program, IModule module, IIndexReporter reporter) {
        this.indexModule(program, module, null, reporter);
    }

    @Override
    public void indexModule(Program program, IModule module, String source, IIndexReporter reporter) {
        try {
            this.setContents(module, source);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error while getting module contents", (Throwable)e);
        }
        CommentsVisitor commentsVisitor = new CommentsVisitor();
        program.accept((Visitor)commentsVisitor);
        this._comments = commentsVisitor.getComments();
        PHPASTVisitor visitor = new PHPASTVisitor(reporter, module);
        program.accept((Visitor)visitor);
        IIndexingASTVisitor[] iIndexingASTVisitorArray = ASTVisitorRegistry.getInstance().getVisitors();
        int n = iIndexingASTVisitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexingASTVisitor v = iIndexingASTVisitorArray[n2];
            v.process(program, reporter, module);
            ++n2;
        }
    }

    public Map<String, String> getAliases() {
        return this._overallAliases;
    }

    public String getNamespace() {
        return this._namespace;
    }

    private static class ClassScopeInfo {
        private IElementEntry classEntry;
        private Map<String, IElementEntry> fields = new HashMap<String, IElementEntry>();

        private ClassScopeInfo(IElementEntry classEntry) {
            this.classEntry = classEntry;
        }

        public IElementEntry getClassEntry() {
            return this.classEntry;
        }

        public Collection<IElementEntry> getFields() {
            return this.fields.values();
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public IElementEntry getField(String fieldName) {
            return this.fields.get(fieldName);
        }

        public void setField(String fieldName, IElementEntry field) {
            this.fields.put(fieldName, field);
        }

        public boolean addFieldTypes(String fieldName, Set<Object> types) {
            IElementEntry fieldEntry = this.fields.get(fieldName);
            if (fieldEntry == null) {
                return false;
            }
            Object entryValue = fieldEntry.getValue();
            if (!(entryValue instanceof VariablePHPEntryValue)) {
                return false;
            }
            VariablePHPEntryValue value = (VariablePHPEntryValue)entryValue;
            for (Object type : types) {
                value.addType(type);
            }
            return true;
        }
    }

    private class PHPASTVisitor
    extends AbstractVisitor {
        private IIndexReporter reporter;
        private IModule module;
        private String currentNamespace = "";
        Map<String, String> aliases = new HashMap<String, String>();
        private ClassScopeInfo currentClass;
        private IElementEntry currentFunction;
        private Stack<Scope> scopes = new Stack();
        boolean localStackReported = false;

        private PHPASTVisitor(IIndexReporter reporter, IModule module) {
            this.reporter = reporter;
            this.module = module;
        }

        public void endVisit(NamespaceDeclaration node) {
            this.endVisitScopeNode((ASTNode)node);
            this.currentNamespace = PDTPHPModuleIndexer.EMPTY_STRING;
            super.endVisit(node);
        }

        public boolean visit(NamespaceDeclaration node) {
            StringBuilder nameBuilder = new StringBuilder();
            if (node.getName() != null) {
                List segments = node.getName().segments();
                int a = 0;
                for (Identifier i : segments) {
                    nameBuilder.append(i.getName());
                    if (++a == segments.size()) continue;
                    nameBuilder.append('\\');
                }
            }
            String name = nameBuilder.toString();
            this.reporter.reportEntry(6, name, new NamespacePHPEntryValue(0, name), this.module);
            this.currentNamespace = name;
            if (PDTPHPModuleIndexer.this.currentOffset == 0 || PDTPHPModuleIndexer.this._namespace == null || PDTPHPModuleIndexer.this.currentOffset > node.getStart()) {
                PDTPHPModuleIndexer.this._namespace = this.currentNamespace;
            }
            this.startVisitScopeNode((ASTNode)node);
            return super.visit(node);
        }

        public boolean visit(UseStatementPart node) {
            NamespaceName name = node.getName();
            String fullName = name.getName();
            Identifier alias = node.getAlias();
            if (alias != null) {
                String aliasName = alias.getName();
                this.aliases.put(aliasName, fullName);
                this.getCurrentScope().aliases.put(aliasName, fullName);
            } else {
                int lastIndexOf = fullName.lastIndexOf(92);
                String aliasName = fullName.substring(lastIndexOf + 1);
                this.aliases.put(aliasName, fullName);
                this.getCurrentScope().aliases.put(aliasName, fullName);
            }
            return super.visit(node);
        }

        public boolean visit(TraitDeclaration traitDeclaration) {
            List interfaces = traitDeclaration.interfaces();
            ArrayList<String> interfaceNames = new ArrayList<String>(interfaces.size());
            for (Identifier interfaceName : interfaces) {
                interfaceNames.add(interfaceName.getName());
            }
            Expression superClassIdentifier = traitDeclaration.getSuperClass();
            String superClassName = null;
            if (superClassIdentifier != null && (superClassIdentifier.getType() == 65 || superClassIdentifier.getType() == 33)) {
                superClassName = ((Identifier)superClassIdentifier).getName();
            }
            TraitPHPEntryValue value = new TraitPHPEntryValue(traitDeclaration.getModifier(), superClassName, interfaceNames, this.currentNamespace);
            value.setStartOffset(traitDeclaration.getStart());
            value.setEndOffset(traitDeclaration.getEnd());
            String className = traitDeclaration.getName().getName();
            IElementEntry currentClassEntry = this.reporter.reportEntry(1, className, value, this.module);
            this.currentClass = new ClassScopeInfo(currentClassEntry);
            return true;
        }

        public boolean visit(ClassDeclaration classDeclaration) {
            List interfaces = classDeclaration.interfaces();
            ArrayList<String> interfaceNames = new ArrayList<String>(interfaces.size());
            for (Identifier interfaceName : interfaces) {
                interfaceNames.add(interfaceName.getName());
            }
            Expression superClassIdentifier = classDeclaration.getSuperClass();
            String superClassName = null;
            if (superClassIdentifier != null && (superClassIdentifier.getType() == 65 || superClassIdentifier.getType() == 33)) {
                superClassName = ((Identifier)superClassIdentifier).getName();
            }
            ClassPHPEntryValue value = new ClassPHPEntryValue(classDeclaration.getModifier(), superClassName, interfaceNames, this.currentNamespace);
            value.setStartOffset(classDeclaration.getStart());
            value.setEndOffset(classDeclaration.getEnd());
            String className = classDeclaration.getName().getName();
            IElementEntry currentClassEntry = this.reporter.reportEntry(1, className, value, this.module);
            this.currentClass = new ClassScopeInfo(currentClassEntry);
            return true;
        }

        public boolean visit(InterfaceDeclaration interfaceDeclaration) {
            int category = 1;
            List interfaces = interfaceDeclaration.interfaces();
            ArrayList<String> interfaceNames = new ArrayList<String>(interfaces.size());
            for (Identifier interfaceName : interfaces) {
                interfaceNames.add(interfaceName.getName());
            }
            ClassPHPEntryValue value = new ClassPHPEntryValue(8, null, interfaceNames, this.currentNamespace);
            value.setStartOffset(interfaceDeclaration.getStart());
            value.setEndOffset(interfaceDeclaration.getEnd());
            IElementEntry currentClassEntry = this.reporter.reportEntry(category, interfaceDeclaration.getName().getName(), value, this.module);
            this.currentClass = new ClassScopeInfo(currentClassEntry);
            return true;
        }

        public boolean visit(TraitUseStatement node) {
            List traitList = node.getTraitList();
            if (!CollectionsUtil.isEmpty((Collection)traitList) && this.currentClass != null && this.currentClass.getClassEntry() != null && this.currentClass.getClassEntry().getValue() instanceof ClassPHPEntryValue) {
                ClassPHPEntryValue classValue = (ClassPHPEntryValue)this.currentClass.getClassEntry().getValue();
                ArrayList<String> traits = new ArrayList<String>(traitList.size());
                for (NamespaceName name : traitList) {
                    traits.add(name.getName());
                }
                classValue.setTraits(traits);
            }
            return super.visit(node);
        }

        public boolean visit(FunctionInvocation functionInvocation) {
            Set<Object> defineTypes;
            Variable vr;
            Expression name;
            FunctionName funcName = functionInvocation.getFunctionName();
            if (funcName == null) {
                return true;
            }
            Expression functionName = funcName.getName();
            if (functionName instanceof Identifier && !PDTPHPModuleIndexer.DEFINE.equals(((Identifier)functionName).getName())) {
                return true;
            }
            if (functionName instanceof Variable && (name = (vr = (Variable)functionName).getName()) instanceof Identifier && !PDTPHPModuleIndexer.DEFINE.equals(((Identifier)name).getName())) {
                return true;
            }
            List parameters = functionInvocation.parameters();
            if (parameters.size() < 2) {
                return true;
            }
            if (((Expression)parameters.get(0)).getType() != 51) {
                return true;
            }
            if (2 != ((Scalar)parameters.get(0)).getScalarType()) {
                return true;
            }
            String defineName = ((Scalar)parameters.get(0)).getStringValue();
            if (defineName.startsWith("\"")) {
                defineName = defineName.substring(1);
            }
            if (defineName.endsWith("\"")) {
                defineName = defineName.substring(0, defineName.length() - 1);
            }
            if (defineName.startsWith("'")) {
                defineName = defineName.substring(1);
            }
            if (defineName.endsWith("'")) {
                defineName = defineName.substring(0, defineName.length() - 1);
            }
            if ((defineTypes = this.countExpressionTypes((Expression)parameters.get(1))) == null) {
                return true;
            }
            VariableInfo info = new VariableInfo(defineName, defineTypes, this.getGlobalScope(), functionInvocation.getStart(), 22);
            this.getGlobalScope().addVariable(info);
            VariablePHPEntryValue entryValue = new VariablePHPEntryValue(22, false, false, true, defineTypes, functionInvocation.getStart(), this.currentNamespace);
            this.reporter.reportEntry(4, defineName, entryValue, this.module);
            return true;
        }

        public boolean visit(FunctionDeclaration functionDeclaration) {
            int[] parameterPositions;
            if (functionDeclaration.getParent() != null && functionDeclaration.getParent() instanceof MethodDeclaration) {
                return true;
            }
            PHPDocBlock comment = PHPDocUtils.findPHPDocComment(PDTPHPModuleIndexer.this._comments, functionDeclaration.getStart(), PDTPHPModuleIndexer.this._contents);
            Identifier functionNameIdentifier = functionDeclaration.getFunctionName();
            if (functionNameIdentifier == null) {
                return true;
            }
            String functionName = functionNameIdentifier.getName();
            List parameters = functionDeclaration.formalParameters();
            LinkedHashMap<String, Set<Object>> parametersMap = null;
            int[] nArray = parameterPositions = parameters == null || parameters.size() == 0 ? null : new int[parameters.size()];
            if (parameters.size() > 0) {
                parametersMap = new LinkedHashMap<String, Set<Object>>(parameters.size());
            }
            ArrayList<Boolean> mandatoryParams = new ArrayList<Boolean>();
            if (parameters != null) {
                int parCount = 0;
                for (FormalParameter parameter : parameters) {
                    Expression rightPartExpr;
                    Set<Object> expressionTypes;
                    Identifier nameIdentifier = parameter.getParameterNameIdentifier();
                    if (nameIdentifier == null) continue;
                    String parameterName = nameIdentifier.getName();
                    parameterPositions[parCount] = parameter.getStart();
                    String parameterType = null;
                    Expression parameterTypeIdentifier = parameter.getParameterType();
                    if (parameterTypeIdentifier != null && (parameterTypeIdentifier.getType() == 33 || parameterTypeIdentifier.getType() == 65)) {
                        parameterType = ((Identifier)parameterTypeIdentifier).getName();
                    }
                    HashSet<Object> types = null;
                    if (parameterType != null) {
                        types = new HashSet<Object>(1);
                        types.add(parameterType);
                    }
                    if (parameter.getDefaultValue() != null && (expressionTypes = this.countExpressionTypes(rightPartExpr = parameter.getDefaultValue())) != null && expressionTypes.size() != 0 && types == null) {
                        types = new HashSet();
                        types.addAll(expressionTypes);
                    }
                    parametersMap.put(parameterName, types);
                    mandatoryParams.add(parameter.getDefaultValue() == null || parameter.isMandatory());
                    ++parCount;
                }
            }
            String[] returnTypes = null;
            if (comment != null) {
                returnTypes = this.applyComment(comment, parametersMap);
            }
            boolean[] mandatories = new boolean[mandatoryParams.size()];
            int j = 0;
            while (j < mandatoryParams.size()) {
                mandatories[j] = (Boolean)mandatoryParams.get(j);
                ++j;
            }
            FunctionPHPEntryValue entryValue = new FunctionPHPEntryValue(0, false, parametersMap, parameterPositions, mandatories, functionDeclaration.getStart(), this.currentNamespace);
            if (returnTypes != null) {
                HashSet<Object> returnTypesSet = new HashSet<Object>();
                String[] stringArray = returnTypes;
                int n = returnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String returnType = stringArray[n2];
                    returnTypesSet.add(returnType);
                    ++n2;
                }
                entryValue.setReturnTypes(returnTypesSet);
            }
            String entryPath = PDTPHPModuleIndexer.EMPTY_STRING;
            if (this.currentClass != null && this.currentClass.getClassEntry() != null) {
                entryPath = String.valueOf(this.currentClass.getClassEntry().getEntryPath()) + '/';
            }
            entryPath = String.valueOf(entryPath) + functionName;
            this.currentFunction = this.reporter.reportEntry(2, entryPath, entryValue, this.module);
            return true;
        }

        public boolean visit(LambdaFunctionDeclaration lambdaFunctionDeclaration) {
            int[] parameterPositions;
            PHPDocBlock comment = PHPDocUtils.findPHPDocComment(PDTPHPModuleIndexer.this._comments, lambdaFunctionDeclaration.getStart(), PDTPHPModuleIndexer.this._contents);
            List parameters = lambdaFunctionDeclaration.formalParameters();
            LinkedHashMap<String, Set<Object>> parametersMap = null;
            int[] nArray = parameterPositions = parameters == null || parameters.size() == 0 ? null : new int[parameters.size()];
            if (parameters.size() > 0) {
                parametersMap = new LinkedHashMap<String, Set<Object>>(parameters.size());
            }
            ArrayList<Boolean> mandatoryParams = new ArrayList<Boolean>();
            if (parameters != null) {
                int parCount = 0;
                for (FormalParameter parameter : parameters) {
                    Expression rightPartExpr;
                    Set<Object> expressionTypes;
                    Identifier nameIdentifier = parameter.getParameterNameIdentifier();
                    if (nameIdentifier == null) continue;
                    String parameterName = nameIdentifier.getName();
                    parameterPositions[parCount] = parameter.getStart();
                    String parameterType = null;
                    Expression parameterTypeIdentifier = parameter.getParameterType();
                    if (parameterTypeIdentifier != null && (parameterTypeIdentifier.getType() == 33 || parameterTypeIdentifier.getType() == 65)) {
                        parameterType = ((Identifier)parameterTypeIdentifier).getName();
                    }
                    HashSet<Object> types = null;
                    if (parameterType != null) {
                        types = new HashSet<Object>(1);
                        types.add(parameterType);
                    }
                    if (parameter.getDefaultValue() != null && (expressionTypes = this.countExpressionTypes(rightPartExpr = parameter.getDefaultValue())) != null && expressionTypes.size() != 0 && types == null) {
                        types = new HashSet();
                        types.addAll(expressionTypes);
                    }
                    parametersMap.put(parameterName, types);
                    mandatoryParams.add(parameter.getDefaultValue() == null || parameter.isMandatory());
                    ++parCount;
                }
            }
            String[] returnTypes = null;
            if (comment != null) {
                returnTypes = this.applyComment(comment, parametersMap);
            }
            boolean[] mandatories = new boolean[mandatoryParams.size()];
            int j = 0;
            while (j < mandatoryParams.size()) {
                mandatories[j] = (Boolean)mandatoryParams.get(j);
                ++j;
            }
            LambdaFunctionPHPEntryValue entryValue = new LambdaFunctionPHPEntryValue(0, parametersMap, parameterPositions, mandatories, lambdaFunctionDeclaration.getStart(), this.currentNamespace);
            if (returnTypes != null) {
                HashSet<Object> returnTypesSet = new HashSet<Object>();
                String[] stringArray = returnTypes;
                int n = returnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String returnType = stringArray[n2];
                    returnTypesSet.add(returnType);
                    ++n2;
                }
                entryValue.setReturnTypes(returnTypesSet);
            }
            String entryPath = PDTPHPModuleIndexer.EMPTY_STRING;
            if (this.currentClass != null) {
                entryPath = String.valueOf(this.currentClass.getClassEntry().getEntryPath()) + '/';
            }
            this.currentFunction = this.reporter.reportEntry(7, entryPath, entryValue, this.module);
            this.startVisitScopeNode((ASTNode)lambdaFunctionDeclaration);
            return true;
        }

        public void endVisit(LambdaFunctionDeclaration lambdaFunctionDeclaration) {
            this.currentFunction = null;
            this.endVisitScopeNode((ASTNode)lambdaFunctionDeclaration);
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            int modifier;
            PHPDocBlock comment = PHPDocUtils.findPHPDocComment(PDTPHPModuleIndexer.this._comments, methodDeclaration.getStart(), PDTPHPModuleIndexer.this._contents);
            FunctionDeclaration functionDeclaration = methodDeclaration.getFunction();
            if (functionDeclaration == null) {
                return true;
            }
            Identifier functionNameIdentifier = functionDeclaration.getFunctionName();
            if (functionNameIdentifier == null) {
                return true;
            }
            String functionName = functionNameIdentifier.getName();
            List parameters = functionDeclaration.formalParameters();
            int[] parameterPositions = parameters == null || parameters.size() == 0 ? null : new int[parameters.size()];
            LinkedHashMap<String, Set<Object>> parametersMap = null;
            if (parameters.size() > 0) {
                parametersMap = new LinkedHashMap<String, Set<Object>>(parameters.size());
            }
            ArrayList<Boolean> mandatoryParams = new ArrayList<Boolean>();
            if (parameters != null) {
                int parCount = 0;
                for (FormalParameter parameter : parameters) {
                    Identifier nameIdentifier = parameter.getParameterNameIdentifier();
                    if (nameIdentifier == null) continue;
                    String parameterName = nameIdentifier.getName();
                    parameterPositions[parCount] = parameter.getStart();
                    String parameterType = null;
                    Expression parameterTypeIdentifier = parameter.getParameterType();
                    if (parameterTypeIdentifier != null && (parameterTypeIdentifier.getType() == 65 || parameterTypeIdentifier.getType() == 33)) {
                        parameterType = ((Identifier)parameterTypeIdentifier).getName();
                    }
                    HashSet<String> types = null;
                    if (parameterType != null) {
                        types = new HashSet<String>(1);
                        types.add(parameterType);
                    }
                    parametersMap.put(parameterName, types);
                    mandatoryParams.add(parameter.getDefaultValue() == null || parameter.isMandatory());
                    ++parCount;
                }
            }
            String[] returnTypes = null;
            if (comment != null) {
                returnTypes = this.applyComment(comment, parametersMap);
            }
            if (!(PHPFlags.isPublic((int)(modifier = methodDeclaration.getModifier())) || PHPFlags.isProtected((int)modifier) || PHPFlags.isPrivate((int)modifier))) {
                modifier |= 0x40;
            }
            boolean[] mandatories = new boolean[mandatoryParams.size()];
            int j = 0;
            while (j < mandatoryParams.size()) {
                mandatories[j] = (Boolean)mandatoryParams.get(j);
                ++j;
            }
            FunctionPHPEntryValue entryValue = new FunctionPHPEntryValue(modifier, true, parametersMap, parameterPositions, mandatories, methodDeclaration.getStart(), this.currentNamespace);
            if (returnTypes != null) {
                HashSet<Object> returnTypesSet = new HashSet<Object>();
                String[] stringArray = returnTypes;
                int n = returnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String returnType = stringArray[n2];
                    returnTypesSet.add(returnType);
                    ++n2;
                }
                entryValue.setReturnTypes(returnTypesSet);
            }
            String entryPath = PDTPHPModuleIndexer.EMPTY_STRING;
            if (this.currentClass != null && this.currentClass.getClassEntry() != null) {
                IElementEntry classEntry = this.currentClass.getClassEntry();
                entryPath = String.valueOf(classEntry.getEntryPath()) + '/';
                if (classEntry.getValue() instanceof TraitPHPEntryValue) {
                    entryValue.setIsTraitMethod(true);
                }
            }
            entryPath = String.valueOf(entryPath) + functionName;
            this.currentFunction = this.reporter.reportEntry(2, entryPath, entryValue, this.module);
            return true;
        }

        public boolean visit(Variable variable) {
            ASTNode parent = variable.getParent();
            if (parent instanceof Assignment) {
                Assignment assignment = (Assignment)parent;
                if (variable.equals(assignment.getLeftHandSide())) {
                    boolean staticDeclaration = parent.getParent() instanceof StaticStatement;
                    return this.handleAssigment(variable, assignment, staticDeclaration);
                }
            } else if (parent instanceof ExpressionStatement) {
                String variableName = this.getVariableName((Expression)variable);
                if (variableName == null) {
                    return true;
                }
                VariableInfo variableInfo = new VariableInfo(variableName, null, this.getCurrentScope(), variable.getStart());
                this.getCurrentScope().addVariable(variableInfo);
            } else if (parent instanceof InfixExpression) {
                String variableName = this.getVariableName((Expression)variable);
                if (variableName == null) {
                    return true;
                }
                InfixExpression expr = (InfixExpression)parent;
                Set<Object> types = this.countInfixExpressionTypes(expr);
                VariableInfo variableInfo = new VariableInfo(variableName, types, this.getCurrentScope(), variable.getStart());
                this.getCurrentScope().addVariable(variableInfo);
            }
            return true;
        }

        public boolean visit(StaticFieldAccess fieldAccess) {
            if (this.currentClass == null) {
                return true;
            }
            if (fieldAccess.getParent() == null || !(fieldAccess.getParent() instanceof Assignment)) {
                return true;
            }
            Expression className = fieldAccess.getClassName();
            if (className == null || className.getType() == 33 && !PDTPHPModuleIndexer.SELF.equals(((Identifier)className).getName())) {
                return true;
            }
            String fieldName = this.getVariableName((Expression)fieldAccess.getField());
            if (fieldName == null) {
                return true;
            }
            Expression value = ((Assignment)fieldAccess.getParent()).getRightHandSide();
            Set<Object> valueTypes = this.countExpressionTypes(value);
            if (valueTypes != null && valueTypes.size() > 0) {
                if (this.currentClass.hasField(fieldName)) {
                    this.currentClass.addFieldTypes(fieldName, valueTypes);
                } else {
                    this.reportField(192, fieldName, valueTypes, fieldAccess.getStart());
                }
            }
            return true;
        }

        public boolean visit(ConstantDeclaration constantDeclaration) {
            if (this.currentClass == null) {
                return true;
            }
            List variableNames = constantDeclaration.names();
            List values = constantDeclaration.initializers();
            int i = 0;
            while (i < variableNames.size()) {
                String variableName = ((Identifier)variableNames.get(i)).getName();
                Expression value = (Expression)values.get(i);
                Set<Object> valueTypes = this.countExpressionTypes(value);
                if (valueTypes != null && valueTypes.size() > 0) {
                    this.reportClassConst(64, variableName, valueTypes, constantDeclaration.getStart());
                }
                ++i;
            }
            return true;
        }

        public boolean visit(FieldAccess fieldAccess) {
            if (fieldAccess == null) {
                return false;
            }
            if (this.currentClass == null) {
                return true;
            }
            if (fieldAccess.getParent() == null || !(fieldAccess.getParent() instanceof Assignment)) {
                return true;
            }
            if (fieldAccess != ((Assignment)fieldAccess.getParent()).getLeftHandSide()) {
                return true;
            }
            VariableBase leftSide = fieldAccess.getDispatcher();
            if (!(leftSide instanceof Variable)) {
                return true;
            }
            String variableName = this.getVariableName((Expression)((Variable)leftSide));
            if (variableName == null || !PDTPHPModuleIndexer.THIS.equals(variableName)) {
                return true;
            }
            VariableBase rightSide = fieldAccess.getMember();
            if (!(rightSide instanceof Variable)) {
                return true;
            }
            String fieldName = this.getVariableName((Expression)((Variable)rightSide));
            if (fieldName == null) {
                return true;
            }
            Expression value = ((Assignment)fieldAccess.getParent()).getRightHandSide();
            Set<Object> valueTypes = this.countExpressionTypes(value);
            if (valueTypes != null && valueTypes.size() > 0) {
                if (this.currentClass.hasField(fieldName)) {
                    this.currentClass.addFieldTypes(fieldName, valueTypes);
                } else {
                    this.reportField(64, fieldName, valueTypes, fieldAccess.getStart());
                }
            }
            return true;
        }

        public boolean visit(FieldsDeclaration fieldsDeclaration) {
            Variable[] variables = fieldsDeclaration.getVariableNames();
            Expression[] initialValues = fieldsDeclaration.getInitialValues();
            int modifier = fieldsDeclaration.getModifier();
            if (!(PHPFlags.isPublic((int)modifier) || PHPFlags.isProtected((int)modifier) || PHPFlags.isPrivate((int)modifier))) {
                modifier |= 0x40;
            }
            int i = 0;
            while (i < variables.length) {
                Variable fieldVariable = variables[i];
                Expression initialValue = initialValues[i];
                String fieldName = this.getVariableName((Expression)fieldVariable);
                if (fieldName != null) {
                    List<TypedDescription> vars;
                    FunctionDocumentation documentation;
                    PHPDocBlock comment;
                    Set<Object> fieldTypes = null;
                    if (initialValue != null) {
                        fieldTypes = this.countExpressionTypes(initialValue);
                    }
                    if ((comment = PHPDocUtils.findPHPDocComment(PDTPHPModuleIndexer.this._comments, fieldsDeclaration.getStart(), PDTPHPModuleIndexer.this._contents)) != null && (documentation = PHPDocUtils.getFunctionDocumentation((IPHPDoc)comment)) != null && (vars = documentation.getVars()) != null && vars.size() != 0) {
                        if (fieldTypes == null) {
                            fieldTypes = new HashSet<Object>();
                        }
                        for (TypedDescription descr : vars) {
                            String[] types;
                            String[] stringArray = types = descr.getTypes();
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String type = stringArray[n2];
                                fieldTypes.add(type.trim());
                                ++n2;
                            }
                        }
                    }
                    this.reportField(modifier, fieldName, fieldTypes, fieldVariable.getStart());
                }
                ++i;
            }
            return true;
        }

        public boolean visit(GlobalStatement globalStatement) {
            List variables = globalStatement.variables();
            HashSet<String> imports = new HashSet<String>();
            for (Variable variable : variables) {
                String varName = this.getVariableName((Expression)variable);
                if (varName == null) continue;
                imports.add(varName);
                this.getGlobalScope().addVariable(new VariableInfo(varName, null, this.getGlobalScope(), globalStatement.getStart()));
            }
            this.getCurrentScope().addGlobalImports(imports);
            return true;
        }

        public boolean visit(ReturnStatement returnStatement) {
            if (this.currentFunction == null) {
                return true;
            }
            Expression expression = returnStatement.getExpression();
            Set<Object> types = this.countExpressionTypes(expression);
            if (!(this.currentFunction.getValue() instanceof FunctionPHPEntryValue)) {
                return true;
            }
            FunctionPHPEntryValue value = (FunctionPHPEntryValue)this.currentFunction.getValue();
            if (types != null) {
                Set<Object> currentTypes = value.getReturnTypes();
                if (currentTypes == null || currentTypes.size() == 0) {
                    currentTypes = new HashSet<Object>();
                }
                currentTypes.addAll(types);
                value.setReturnTypes(currentTypes);
            }
            return true;
        }

        public void endVisit(ClassDeclaration classDeclaration) {
            this.currentClass = null;
        }

        public void endVisit(InterfaceDeclaration interfaceDeclaration) {
            this.currentClass = null;
        }

        public void endVisit(FunctionDeclaration functionDeclaration) {
            this.currentFunction = null;
        }

        public void endVisit(MethodDeclaration methodDeclaration) {
            this.currentFunction = null;
        }

        public void endVisit(Program program) {
            this.endVisitScopeNode((ASTNode)program);
        }

        public boolean visit(Program program) {
            this.startVisitScopeNode((ASTNode)program);
            return true;
        }

        public boolean visit(Block block) {
            if (block.getParent() instanceof NamespaceDeclaration) {
                return true;
            }
            this.startVisitScopeNode(block.getParent());
            this.addBlockVariables(block);
            return true;
        }

        public boolean visit(CatchClause catchClause) {
            return true;
        }

        public boolean visit(DoStatement doStatement) {
            return true;
        }

        public boolean visit(ForEachStatement forEachStatement) {
            return true;
        }

        public boolean visit(ForStatement forStatement) {
            this.startVisitScopeNode((ASTNode)forStatement);
            return true;
        }

        public boolean visit(IfStatement ifStatement) {
            return true;
        }

        public boolean visit(SwitchStatement switchStatement) {
            return true;
        }

        public boolean visit(TryStatement tryStatement) {
            return true;
        }

        public boolean visit(WhileStatement whileStatement) {
            return true;
        }

        public boolean visit(Include include) {
            Expression expr = include.getExpression();
            if (expr != null && (expr.getType() == 62 || expr.getType() == 51)) {
                Expression subExpr = null;
                subExpr = expr instanceof Scalar ? expr : ((ParenthesisExpression)expr).getExpression();
                if (subExpr == null) {
                    return true;
                }
                String includePath = null;
                int type = subExpr.getType();
                if (type == 51) {
                    includePath = ((Scalar)subExpr).getStringValue();
                } else if (type == 37) {
                    try {
                        includePath = PDTPHPModuleIndexer.this._contents.substring(subExpr.getStart(), subExpr.getEnd());
                    }
                    catch (Exception e) {
                        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"A problem while visiting an include statement", (Throwable)e);
                    }
                }
                if (includePath != null) {
                    if (includePath == null || includePath.length() == 0) {
                        return true;
                    }
                    int pathStartOffset = subExpr.getStart();
                    if (includePath.startsWith("\"") || includePath.startsWith("'")) {
                        includePath = includePath.substring(1);
                        ++pathStartOffset;
                    }
                    if (includePath.endsWith("\"") || includePath.endsWith("'")) {
                        includePath = includePath.substring(0, includePath.length() - 1);
                    }
                    int pdtIncludeType = include.getIncludeType();
                    int includeType = -1;
                    switch (pdtIncludeType) {
                        case 2: {
                            includeType = IncludePHPEntryValue.INCLUDE_TYPE;
                            break;
                        }
                        case 3: {
                            includeType = IncludePHPEntryValue.INCLUDE_ONCE_TYPE;
                            break;
                        }
                        case 0: {
                            includeType = IncludePHPEntryValue.REQUIRE_TYPE;
                            break;
                        }
                        case 1: {
                            includeType = IncludePHPEntryValue.REQUIRE_ONCE_TYPE;
                        }
                    }
                    IncludePHPEntryValue value = new IncludePHPEntryValue(includePath, include.getStart(), include.getEnd(), pathStartOffset, includeType);
                    this.reporter.reportEntry(5, PDTPHPModuleIndexer.EMPTY_STRING, value, this.module);
                }
            }
            return true;
        }

        public void endVisit(Block block) {
            if (block.getParent() instanceof NamespaceDeclaration) {
                return;
            }
            this.endVisitScopeNode((ASTNode)block);
        }

        public void endVisit(CatchClause catchClause) {
        }

        public void endVisit(DoStatement doStatement) {
        }

        public void endVisit(ForEachStatement forEachStatement) {
        }

        public void endVisit(ForStatement forStatement) {
            this.endVisitScopeNode((ASTNode)forStatement);
        }

        public void endVisit(IfStatement ifStatement) {
        }

        public void endVisit(SwitchStatement switchStatement) {
        }

        public void endVisit(TryStatement tryStatement) {
        }

        public void endVisit(WhileStatement whileStatement) {
        }

        private boolean handleAssigment(Variable variable, Assignment assigment, boolean staticDeclaration) {
            Expression value = assigment.getRightHandSide();
            String variableName = this.getVariableName((Expression)variable);
            if (variableName == null) {
                return true;
            }
            Set<Object> rightSideTypes = this.countExpressionTypes(value);
            VariableInfo variableInfo = new VariableInfo(variableName, rightSideTypes, this.getCurrentScope(), variable.getStart(), staticDeclaration ? 128 : 0);
            this.getCurrentScope().addVariable(variableInfo);
            return true;
        }

        String getVariableEntryPath(Variable variable) {
            String entryPath = PDTPHPModuleIndexer.EMPTY_STRING;
            if (this.currentFunction != null) {
                entryPath = String.valueOf(this.currentFunction.getEntryPath()) + '/';
            } else if (this.currentClass != null) {
                entryPath = String.valueOf(this.currentClass.getClassEntry().getEntryPath()) + '/';
            }
            String varName = this.getVariableName((Expression)variable);
            if (varName == null) {
                return null;
            }
            entryPath = String.valueOf(entryPath) + varName;
            return entryPath;
        }

        private String getVariableName(Expression variable) {
            if (variable == null) {
                return null;
            }
            if (variable.getType() == 60) {
                variable = ((Variable)variable).getName();
            }
            if (variable.getType() == 33) {
                return ((Identifier)variable).getName();
            }
            return null;
        }

        private void startVisitScopeNode(ASTNode node) {
            Scope parent = null;
            if (!this.scopes.isEmpty()) {
                parent = this.scopes.peek();
            }
            IElementEntry currentEntry = null;
            if (node instanceof FunctionDeclaration || node instanceof LambdaFunctionDeclaration) {
                currentEntry = this.currentFunction;
            } else if (node instanceof ClassDeclaration) {
                currentEntry = this.currentClass.getClassEntry();
            }
            Scope scope = new Scope(node, parent, currentEntry);
            this.scopes.push(scope);
            if (PDTPHPModuleIndexer.this._resolvedVarComments != null && PDTPHPModuleIndexer.this._resolvedVarComments.get(node) != null) {
                for (VarComment comment : (List)PDTPHPModuleIndexer.this._resolvedVarComments.get(node)) {
                    String variableName = comment.getVariableReference().getName();
                    if (variableName.startsWith(PDTPHPModuleIndexer.DOLLAR_SIGN)) {
                        variableName = variableName.substring(1);
                    }
                    VariableInfo variableInfo = new VariableInfo(variableName, comment.getTypeReferencesNames(), scope, comment.getStart(), 0);
                    this.getCurrentScope().addVariable(variableInfo);
                }
            }
        }

        private void endVisitScopeNode(ASTNode node) {
            if (!this.scopes.isEmpty()) {
                if (!PDTPHPModuleIndexer.this.globalMode && !this.localStackReported && node.getEnd() > PDTPHPModuleIndexer.this.currentOffset) {
                    this.reportStack(this.scopes);
                    this.localStackReported = true;
                }
                Scope scope = this.scopes.pop();
                this.reportGlobalScopeVariables(scope);
            }
        }

        private Scope getCurrentScope() {
            return this.scopes.peek();
        }

        private Scope getGlobalScope() {
            return (Scope)this.scopes.get(0);
        }

        private void reportGlobalScopeVariables(Scope scope) {
            int rootType = scope.getRoot().getType();
            if (!(!PDTPHPModuleIndexer.this.globalMode && rootType != 64 || rootType != 46 && rootType != 64)) {
                for (VariableInfo info : scope.getVariables()) {
                    VariablePHPEntryValue entryValue = new VariablePHPEntryValue(0, false, false, false, info.getVariableTypes(), info.getNodeStart(), this.currentNamespace);
                    String entryPath = info.getName();
                    int category = PHPFlags.isNamedConstant((int)info.getModifier()) ? 4 : 3;
                    this.reporter.reportEntry(category, entryPath, entryValue, this.module);
                }
            }
        }

        private Set<Object> countVariableTypes(String variableName, Scope currentScope) {
            Set<Object> types;
            FunctionPHPEntryValue entryValue;
            Map<String, Set<Object>> parameters;
            IElementEntry entry;
            HashSet<Object> result = new HashSet<Object>();
            VariableInfo variable = currentScope.getVariable(variableName);
            if (variable != null) {
                result.addAll(variable.getVariableTypes());
            }
            if ((entry = this.findFunctionOrMethodParent(currentScope)) != null && (parameters = (entryValue = (FunctionPHPEntryValue)entry.getValue()).getParameters()) != null && (types = parameters.get(variableName)) != null) {
                result.addAll(types);
            }
            return result;
        }

        private IElementEntry findFunctionOrMethodParent(Scope scope) {
            Scope currentScope = scope;
            while (currentScope != null) {
                IElementEntry entry = currentScope.getEntry();
                if (entry != null && entry.getValue() instanceof FunctionPHPEntryValue) {
                    return entry;
                }
                currentScope = currentScope.getParent();
            }
            return null;
        }

        private Set<Object> countInfixExpressionTypes(InfixExpression expr) {
            int operator = expr.getOperator();
            String type = null;
            switch (operator) {
                case 16: {
                    type = "_string";
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    type = "_boolean";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    type = "_string";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    type = "_real";
                    break;
                }
                case 22: 
                case 23: {
                    type = "_integer";
                }
            }
            HashSet<Object> result = new HashSet<Object>(1);
            result.add(type);
            return result;
        }

        private CallPath getPathByStaticDispatch(StaticDispatch dispatch) {
            CallPath result = new CallPath();
            Expression classNameIdentifier = dispatch.getClassName();
            if (classNameIdentifier == null || classNameIdentifier.getType() != 33 && classNameIdentifier.getType() != 65 && classNameIdentifier.getType() != 60) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Expected an identifier, variable or namespace-name", (Throwable)new Exception("Missing identifier"));
                return null;
            }
            String className = null;
            className = classNameIdentifier.getType() == 60 ? this.getVariableName((Expression)((Variable)classNameIdentifier)) : ((Identifier)classNameIdentifier).getName();
            result.setClassEntry(className);
            ASTNode member = dispatch.getMember();
            String memberName = null;
            boolean field = true;
            if (member instanceof Variable) {
                Variable currentField = (Variable)member;
                memberName = this.getVariableName((Expression)currentField);
                if (memberName == null) {
                    return null;
                }
                field = true;
            } else if (member instanceof FunctionInvocation) {
                FunctionInvocation funcInvocation = (FunctionInvocation)member;
                memberName = this.getFunctionNameByInvocation(funcInvocation);
                if (memberName == null) {
                    return null;
                }
                field = false;
            } else {
                return null;
            }
            if (field) {
                result.addVariableEntry(memberName);
            } else {
                result.addMethodEntry(memberName);
            }
            return result;
        }

        private CallPath getPathByDispatch(Dispatch dispatch) {
            CallPath result = new CallPath();
            Dispatch currentDispatch = dispatch;
            while (currentDispatch != null) {
                String dispatecherName;
                VariableBase currentDispatcher = currentDispatch.getDispatcher();
                String memberName = null;
                boolean field = true;
                VariableBase member = currentDispatch.getMember();
                if (member instanceof Variable) {
                    Variable currentField = (Variable)member;
                    memberName = this.getVariableName((Expression)currentField);
                    if (memberName == null) {
                        return null;
                    }
                    field = true;
                } else if (member instanceof FunctionInvocation) {
                    FunctionInvocation funcInvocation = (FunctionInvocation)member;
                    memberName = this.getFunctionNameByInvocation(funcInvocation);
                    if (memberName == null) {
                        return null;
                    }
                    field = false;
                } else {
                    return null;
                }
                if (field) {
                    result.insertVariableEntry(memberName);
                } else {
                    result.insertMethodEntry(memberName);
                }
                if (currentDispatcher instanceof Dispatch) {
                    currentDispatch = (Dispatch)currentDispatcher;
                    continue;
                }
                if (currentDispatcher instanceof StaticDispatch) {
                    CallPath staticDispatchCallPath = this.getPathByStaticDispatch((StaticDispatch)currentDispatcher);
                    if (staticDispatchCallPath == null) {
                        return null;
                    }
                    staticDispatchCallPath.addPath(result);
                    return staticDispatchCallPath;
                }
                if (currentDispatcher instanceof Variable) {
                    dispatecherName = this.getVariableName((Expression)((Variable)currentDispatcher));
                    if (dispatecherName == null) {
                        return null;
                    }
                    result.insertVariableEntry(dispatecherName);
                    break;
                }
                if (currentDispatcher instanceof FunctionInvocation) {
                    dispatecherName = this.getFunctionNameByInvocation((FunctionInvocation)currentDispatcher);
                    if (dispatecherName == null) {
                        return null;
                    }
                    result.insertMethodEntry(dispatecherName);
                    break;
                }
                return null;
            }
            return result;
        }

        private Set<Object> countExpressionTypes(Expression expression) {
            Set<Object> result = null;
            if (expression instanceof Quote && ((Quote)expression).getQuoteType() == 2) {
                result = new HashSet();
                result.add("_string");
            }
            if (expression instanceof LambdaFunctionDeclaration) {
                result = new HashSet<String>(1);
                StringBuilder type = new StringBuilder();
                type.append("_lambda");
                type.append('(');
                LambdaFunctionDeclaration lf = (LambdaFunctionDeclaration)expression;
                List formalParameters = lf.formalParameters();
                int i = 0;
                for (FormalParameter p : formalParameters) {
                    String name;
                    Expression parameterName = p.getParameterName();
                    if (parameterName == null || parameterName.getType() != 33 && parameterName.getType() != 65 || !(name = ((Identifier)parameterName).getName()).startsWith(PDTPHPModuleIndexer.DOLLAR_SIGN)) continue;
                    type.append(name.substring(1));
                    if (++i == formalParameters.size()) continue;
                    type.append(',');
                }
                type.append(')');
                result.add(type.toString());
                return result;
            }
            if (expression instanceof UnaryOperation) {
                UnaryOperation unaryOperation = (UnaryOperation)expression;
                expression = unaryOperation.getExpression();
            }
            if (expression instanceof Scalar) {
                Scalar scalar = (Scalar)expression;
                result = this.countScalarTypes(scalar);
            } else if (expression instanceof Variable) {
                Variable rightSideVar = (Variable)expression;
                String rightSideVarName = this.getVariableName((Expression)rightSideVar);
                if (rightSideVarName == null) {
                    return null;
                }
                result = this.countVariableTypes(rightSideVarName, this.getCurrentScope());
            } else if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation creation = (ClassInstanceCreation)expression;
                result = this.countInstanceCreationTypes(creation);
            } else if (expression instanceof FieldAccess || expression instanceof MethodInvocation) {
                Dispatch dispatch = (Dispatch)expression;
                result = this.countDispatchTypes(dispatch);
            } else if (expression instanceof StaticDispatch) {
                StaticDispatch staticDispatch = (StaticDispatch)expression;
                result = this.countStaticDispatchTypes(staticDispatch);
            } else if (expression instanceof FunctionInvocation) {
                FunctionInvocation invocation = (FunctionInvocation)expression;
                result = this.countFunctionInvocationTypes(invocation);
            } else if (expression instanceof InfixExpression) {
                InfixExpression infix = (InfixExpression)expression;
                result = this.countInfixExpressionTypes(infix);
            }
            return result;
        }

        private Set<Object> countFunctionInvocationTypes(FunctionInvocation invocation) {
            String functionName = this.getFunctionNameByInvocation(invocation);
            if (functionName == null) {
                return null;
            }
            FunctionPathReference reference = new FunctionPathReference(functionName, null);
            HashSet<Object> result = new HashSet<Object>(1);
            result.add(reference);
            return result;
        }

        private Set<Object> countScalarTypes(Scalar scalar) {
            int intType = scalar.getScalarType();
            String type = PDTPHPModuleIndexer.typeToString(intType);
            HashSet<Object> result = new HashSet<Object>(1);
            result.add(type);
            return result;
        }

        private Set<Object> countInstanceCreationTypes(ClassInstanceCreation creation) {
            ClassName className = creation.getClassName();
            if (className == null) {
                return null;
            }
            Expression classNameExpr = className.getName();
            if (classNameExpr == null || !(classNameExpr instanceof Identifier) && !(classNameExpr instanceof NamespaceName)) {
                return null;
            }
            String clName = null;
            if (classNameExpr instanceof Identifier) {
                clName = ((Identifier)classNameExpr).getName();
                String string = this.aliases.get(clName);
                if (string != null) {
                    clName = string;
                }
                if (this.currentNamespace != null && this.currentNamespace.length() > 0) {
                    clName = String.valueOf(this.currentNamespace) + '\\' + clName;
                }
            } else if (classNameExpr instanceof NamespaceName) {
                NamespaceName na = (NamespaceName)classNameExpr;
                if (na.isGlobal()) {
                    clName = na.getName();
                } else if (na.isCurrent()) {
                    if (this.currentNamespace != null && this.currentNamespace.length() > 0) {
                        clName = String.valueOf(this.currentNamespace) + '\\' + na.getName();
                    }
                } else {
                    Identifier identifier = (Identifier)na.segments().get(0);
                    String name = identifier.getName();
                    String alias = this.aliases.get(name);
                    if (alias != null) {
                        clName = na.getName();
                        clName = String.valueOf(alias) + clName.substring(name.length());
                    } else {
                        clName = String.valueOf(this.currentNamespace) + '\\' + na.getName();
                    }
                }
            }
            if (clName == null) {
                return null;
            }
            HashSet<Object> result = new HashSet<Object>(1);
            if (PDTPHPModuleIndexer.SELF.equals(clName)) {
                if (this.currentClass != null && this.currentClass.getClassEntry() != null) {
                    result.add(this.currentClass.getClassEntry().getEntryPath());
                    return result;
                }
                return null;
            }
            result.add(clName);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Set<Object> countStaticDispatchTypes(StaticDispatch dispatch) {
            HashSet<StaticPathReference> result = null;
            CallPath path = this.getPathByStaticDispatch(dispatch);
            if (path == null) return null;
            if (path.getSize() < 2) {
                return null;
            }
            CallPath remainingPath = path.subPath(1);
            List<CallPath.Entry> pathEntries = path.getEntries();
            CallPath.Entry dispatchEntry = pathEntries.get(0);
            if (dispatchEntry instanceof CallPath.ClassEntry && PDTPHPModuleIndexer.SELF.equals(dispatchEntry.getName())) {
                if (this.currentClass == null) return null;
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                IElementEntry classEntry = this.currentClass.getClassEntry();
                if (classEntry == null) return result;
                dispatcherTypes.add(ElementsIndexingUtils.getFirstNameInPath(classEntry.getEntryPath()));
                StaticPathReference reference = new StaticPathReference(dispatcherTypes, remainingPath);
                result = new HashSet(1);
                result.add(reference);
                return result;
            } else {
                if (!(dispatchEntry instanceof CallPath.ClassEntry)) return null;
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                dispatcherTypes.add(dispatchEntry.getName());
                StaticPathReference reference = new StaticPathReference(dispatcherTypes, remainingPath);
                result = new HashSet<StaticPathReference>(1);
                result.add(reference);
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Set<Object> countDispatchTypes(Dispatch dispatch) {
            HashSet<AbstractPathReference> result = null;
            CallPath path = this.getPathByDispatch(dispatch);
            if (path == null) return null;
            if (path.getSize() < 2) {
                return null;
            }
            CallPath remainingPath = path.subPath(1);
            List<CallPath.Entry> pathEntries = path.getEntries();
            CallPath.Entry dispatchEntry = pathEntries.get(0);
            if (dispatchEntry instanceof CallPath.VariableEntry && PDTPHPModuleIndexer.THIS.equals(dispatchEntry.getName())) {
                if (this.currentClass == null) return null;
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                IElementEntry classEntry = this.currentClass.getClassEntry();
                if (classEntry == null) return result;
                dispatcherTypes.add(ElementsIndexingUtils.getFirstNameInPath(classEntry.getEntryPath()));
                VariablePathReference reference = new VariablePathReference(dispatcherTypes, remainingPath);
                result = new HashSet(1);
                result.add(reference);
                return result;
            } else if (dispatchEntry instanceof CallPath.ClassEntry && PDTPHPModuleIndexer.SELF.equals(dispatchEntry.getName())) {
                if (this.currentClass == null || this.currentClass.getClassEntry() == null) return null;
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                dispatcherTypes.add(ElementsIndexingUtils.getFirstNameInPath(this.currentClass.getClassEntry().getEntryPath()));
                StaticPathReference reference = new StaticPathReference(dispatcherTypes, remainingPath);
                result = new HashSet(1);
                result.add(reference);
                return result;
            } else if (dispatchEntry instanceof CallPath.ClassEntry) {
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                dispatcherTypes.add(dispatchEntry.getName());
                StaticPathReference reference = new StaticPathReference(dispatcherTypes, remainingPath);
                result = new HashSet<AbstractPathReference>(1);
                result.add(reference);
                return result;
            } else if (dispatchEntry instanceof CallPath.VariableEntry) {
                Set<Object> dispatcherTypes = this.countVariableTypes(dispatchEntry.getName(), this.getCurrentScope());
                if (dispatcherTypes == null) {
                    return null;
                }
                VariablePathReference reference = new VariablePathReference(dispatcherTypes, remainingPath);
                result = new HashSet(1);
                result.add(reference);
                return result;
            } else {
                if (!(dispatchEntry instanceof CallPath.MethodEntry)) return null;
                String methodEntryPath = ((CallPath.MethodEntry)dispatchEntry).getName();
                FunctionPathReference reference = new FunctionPathReference(methodEntryPath, remainingPath);
                result = new HashSet(1);
                result.add(reference);
            }
            return result;
        }

        private String getFunctionNameByInvocation(FunctionInvocation invocation) {
            FunctionName funcName = invocation.getFunctionName();
            if (funcName == null) {
                return null;
            }
            Expression funcNameExpression = funcName.getName();
            if (funcNameExpression == null) {
                return null;
            }
            if (funcNameExpression instanceof Variable) {
                return this.getVariableName((Expression)((Variable)funcNameExpression));
            }
            if (funcNameExpression instanceof Identifier) {
                return ((Identifier)funcNameExpression).getName();
            }
            return null;
        }

        private void reportStack(List<Scope> stack) {
            if (stack.isEmpty()) {
                return;
            }
            int currentScopeDepth = 0;
            int i = 0;
            while (i < stack.size()) {
                Scope currentScope = stack.get(i);
                Set<String> currentGlobalImports = currentScope.getGlobalImports();
                if (currentGlobalImports != null) {
                    PDTPHPModuleIndexer.this._overallGlobalImports.addAll(currentGlobalImports);
                }
                ++i;
            }
            PDTPHPModuleIndexer.this._overallAliases.putAll(this.aliases);
            Scope currentScope = null;
            int i2 = stack.size() - 1;
            while (i2 >= 0) {
                currentScopeDepth = i2;
                currentScope = stack.get(i2);
                ASTNode root = currentScope.getRoot();
                if (root != null && root.getStart() < PDTPHPModuleIndexer.this.currentOffset) break;
                --i2;
            }
            if (currentScope == null) {
                return;
            }
            PDTPHPModuleIndexer.this.isReportedStackGlobal = currentScope.isGlobalScope();
            PDTPHPModuleIndexer.this.isReportedScopeUnderClass = this.checkIfScopeIsUnderClass(stack, currentScopeDepth);
            Set<VariableInfo> variables = currentScope.getVariables();
            boolean localVariables = !currentScope.isGlobalScope();
            for (VariableInfo varInfo : variables) {
                if (varInfo.getNodeStart() > PDTPHPModuleIndexer.this.currentOffset) continue;
                String entryPath = varInfo.getName();
                VariablePHPEntryValue value = new VariablePHPEntryValue(varInfo.getModifier(), false, localVariables, false, varInfo.getVariableTypes(), varInfo.getNodeStart(), this.currentNamespace);
                int category = PHPFlags.isNamedConstant((int)varInfo.getModifier()) ? 4 : 3;
                this.reporter.reportEntry(category, entryPath, value, this.module);
            }
            int i3 = stack.size() - 1;
            while (i3 >= 0) {
                Scope scope = stack.get(i3);
                IElementEntry entry = scope.getEntry();
                if (entry != null && (entry.getCategory() == 2 && entry.getValue() instanceof FunctionPHPEntryValue || entry.getCategory() == 7 && entry.getValue() instanceof LambdaFunctionPHPEntryValue)) {
                    IPHPFunctionEntryValue val = (IPHPFunctionEntryValue)entry.getValue();
                    Map<String, Set<Object>> parameters = val.getParameters();
                    int[] parameterStartPositions = val.getParameterStartPositions();
                    if (parameters != null && !parameters.isEmpty()) {
                        int parCount = 0;
                        for (Map.Entry<String, Set<Object>> parEntry : parameters.entrySet()) {
                            String entryPath = parEntry.getKey();
                            VariablePHPEntryValue value = new VariablePHPEntryValue(0, true, false, false, parEntry.getValue(), parameterStartPositions == null || parameterStartPositions.length == 0 ? val.getStartOffset() : parameterStartPositions[parCount], this.currentNamespace);
                            this.reporter.reportEntry(3, entryPath, value, this.module);
                            ++parCount;
                        }
                    }
                }
                --i3;
            }
        }

        private boolean checkIfScopeIsUnderClass(List<Scope> stack, int currentScopeDepth) {
            int i = currentScopeDepth;
            while (i >= 0) {
                Scope scope = (Scope)this.scopes.get(i);
                IElementEntry entry = scope.getEntry();
                if (entry != null && entry.getCategory() == 1) {
                    return true;
                }
                --i;
            }
            return false;
        }

        String getScopePath(List<Scope> stack, int pos) {
            StringBuffer result = new StringBuffer();
            int i = pos;
            while (i >= 0) {
                String className;
                Identifier classNameIdentifier;
                String functionName;
                Identifier funcNameIdentifier;
                Scope currentScope = stack.get(i);
                ASTNode root = currentScope.getRoot();
                if (root instanceof FunctionDeclaration) {
                    funcNameIdentifier = ((FunctionDeclaration)root).getFunctionName();
                    if (funcNameIdentifier != null && (functionName = funcNameIdentifier.getName()) != null) {
                        result.insert(0, String.valueOf(functionName) + '/');
                    }
                } else if (root instanceof MethodDeclaration) {
                    funcNameIdentifier = ((MethodDeclaration)root).getFunction().getFunctionName();
                    if (funcNameIdentifier != null && (functionName = funcNameIdentifier.getName()) != null) {
                        result.insert(0, String.valueOf(functionName) + '/');
                    }
                } else if (root instanceof ClassDeclaration && (classNameIdentifier = ((ClassDeclaration)root).getName()) != null && (className = classNameIdentifier.getName()) != null) {
                    result.insert(0, String.valueOf(className) + '/');
                }
                --i;
            }
            return result.toString();
        }

        private String[] applyComment(PHPDocBlock comment, Map<String, Set<Object>> parametersMap) {
            TypedDescription returnDescr;
            block14: {
                FunctionDocumentation doc;
                block13: {
                    doc = PHPDocUtils.getFunctionDocumentation((IPHPDoc)comment);
                    if (doc != null) break block13;
                    return null;
                }
                try {
                    TypedDescription[] params = doc.getParams();
                    if (params != null && params.length != 0) {
                        TypedDescription[] typedDescriptionArray = params;
                        int n = params.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TypedDescription param = typedDescriptionArray[n2];
                            String paramName = param.getName();
                            if (paramName != null && paramName.length() != 0) {
                                if (paramName.startsWith(PDTPHPModuleIndexer.DOLLAR_SIGN)) {
                                    paramName = paramName.substring(1);
                                }
                                String[] types = param.getTypes();
                                if (parametersMap != null) {
                                    Set<Object> toSetParams = parametersMap.get(paramName);
                                    if (parametersMap.containsKey(paramName)) {
                                        if (toSetParams == null && types != null) {
                                            toSetParams = new HashSet<Object>();
                                            parametersMap.put(paramName, toSetParams);
                                        }
                                        if (types != null) {
                                            String[] stringArray = types;
                                            int n3 = types.length;
                                            int n4 = 0;
                                            while (n4 < n3) {
                                                String type = stringArray[n4];
                                                toSetParams.add(type);
                                                ++n4;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    if ((returnDescr = doc.getReturn()) != null) break block14;
                    return null;
                }
                catch (Throwable th) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP Module Indexer - Error while applying a comment (applyComment)", (Throwable)th, (String)"com.aptana.editor.php/debug/indexer");
                    return null;
                }
            }
            return returnDescr.getTypes();
        }

        private IElementEntry reportField(int modifier, String fieldName, Set<Object> fieldTypes, int pos) {
            VariablePHPEntryValue entryValue = new VariablePHPEntryValue(modifier, false, false, true, fieldTypes, pos, this.currentNamespace);
            if (this.currentClass != null && this.currentClass.getClassEntry() != null) {
                String entryPath = String.valueOf(this.currentClass.getClassEntry().getEntryPath()) + '/';
                entryPath = String.valueOf(entryPath) + fieldName;
                IElementEntry result = this.reporter.reportEntry(3, entryPath, entryValue, this.module);
                this.currentClass.setField(fieldName, result);
                return result;
            }
            return null;
        }

        private IElementEntry reportClassConst(int modifier, String fieldName, Set<Object> fieldTypes, int pos) {
            modifier |= 0x80;
            VariablePHPEntryValue entryValue = new VariablePHPEntryValue(modifier |= 4, false, false, true, fieldTypes, pos, this.currentNamespace);
            if (this.currentClass != null && this.currentClass.getClassEntry() != null) {
                String entryPath = String.valueOf(this.currentClass.getClassEntry().getEntryPath()) + '/';
                entryPath = String.valueOf(entryPath) + fieldName;
                IElementEntry result = this.reporter.reportEntry(4, entryPath, entryValue, this.module);
                return result;
            }
            return null;
        }

        private void addBlockVariables(Block block) {
            ASTNode blockParent = block.getParent();
            if (blockParent instanceof CatchClause) {
                this.addCatchClauseVariables((CatchClause)blockParent);
            } else if (blockParent instanceof ForStatement) {
                this.addForVariables((ForStatement)blockParent);
            } else if (blockParent instanceof ForEachStatement) {
                this.addForEachVariables((ForEachStatement)blockParent);
            } else if (blockParent instanceof LambdaFunctionDeclaration) {
                VariableInfo info;
                LambdaFunctionDeclaration lambdaFunctionDeclaration = (LambdaFunctionDeclaration)blockParent;
                List formalParameters = lambdaFunctionDeclaration.formalParameters();
                for (FormalParameter p : formalParameters) {
                    String name;
                    Expression varName = p.getParameterName();
                    if (varName == null || varName.getType() != 33 && varName.getType() != 65 || !(name = ((Identifier)varName).getName()).startsWith(PDTPHPModuleIndexer.DOLLAR_SIGN)) continue;
                    info = new VariableInfo(name.substring(1), null, this.getCurrentScope(), lambdaFunctionDeclaration.getStart());
                    this.getCurrentScope().addVariable(info);
                }
                List lexicalVariables = lambdaFunctionDeclaration.lexicalVariables();
                for (Expression p : lexicalVariables) {
                    String varName;
                    if (p.getType() != 33 && p.getType() != 65 || (varName = ((Identifier)p).getName()) == null || !varName.startsWith(PDTPHPModuleIndexer.DOLLAR_SIGN)) continue;
                    info = new VariableInfo(varName.substring(1), null, this.getCurrentScope(), lambdaFunctionDeclaration.getStart());
                    this.getCurrentScope().addVariable(info);
                }
            }
        }

        private void addForEachVariables(ForEachStatement foreachStatement) {
            VariableInfo info;
            String varName;
            Expression key = foreachStatement.getKey();
            Expression value = foreachStatement.getValue();
            if (key != null && key instanceof Variable && (varName = this.getVariableName((Expression)((Variable)key))) != null) {
                info = new VariableInfo(varName, null, this.getCurrentScope(), key.getStart());
                this.getCurrentScope().addVariable(info);
            }
            if (value != null && value instanceof Variable && (varName = this.getVariableName((Expression)((Variable)value))) != null) {
                info = new VariableInfo(varName, null, this.getCurrentScope(), value.getStart());
                this.getCurrentScope().addVariable(info);
            }
        }

        private void addForVariables(ForStatement forStatement) {
            List initializations = forStatement.initializers();
            if (initializations == null || initializations.size() == 0) {
                return;
            }
            for (Expression initialization : initializations) {
                Set<Object> types;
                String varName;
                Assignment assigment;
                VariableBase var;
                if (!(initialization instanceof Assignment) || !((var = (assigment = (Assignment)initialization).getLeftHandSide()) instanceof Variable) || (varName = this.getVariableName((Expression)((Variable)var))) == null || (types = this.countExpressionTypes(assigment.getRightHandSide())) == null || types.size() == 0) continue;
                VariableInfo info = new VariableInfo(varName, types, this.getCurrentScope(), var.getStart());
                this.getCurrentScope().addVariable(info);
            }
        }

        private void addCatchClauseVariables(CatchClause clause) {
            Variable var = clause.getVariable();
            String varName = this.getVariableName((Expression)var);
            if (varName != null) {
                VariableInfo info = new VariableInfo(varName, "Exception", this.getCurrentScope(), var.getStart());
                this.getCurrentScope().addVariable(info);
            }
        }
    }

    private static class Scope {
        private ASTNode root;
        private IElementEntry entry;
        private Map<String, VariableInfo> variables;
        private Scope parent;
        private Set<String> globalImports = new HashSet<String>();
        private Map<String, String> aliases = new HashMap<String, String>();

        private Scope(ASTNode root, Scope parent) {
            this.root = root;
            this.parent = parent;
            this.entry = null;
            this.variables = new HashMap<String, VariableInfo>(1);
        }

        private Scope(ASTNode root, Scope parent, IElementEntry entry) {
            this.root = root;
            this.parent = parent;
            this.entry = entry;
            this.variables = new HashMap<String, VariableInfo>(1);
        }

        public Set<String> getGlobalImports() {
            return this.globalImports;
        }

        public Map<String, String> getAliases() {
            return this.aliases;
        }

        public void addGlobalImports(Set<String> imports) {
            this.globalImports.addAll(imports);
        }

        public void addGlobalImport(String importVariable) {
            this.globalImports.add(importVariable);
        }

        public boolean isGlobalScope() {
            return this.root instanceof Program;
        }

        public void addVariable(VariableInfo variable) {
            VariableInfo existingVariable = this.getVariable(variable.getName());
            if (existingVariable != null) {
                if (variable.getVariableTypes() != null && !variable.getVariableTypes().isEmpty()) {
                    if (this.equals(existingVariable.getScope())) {
                        existingVariable.setVariableTypes(variable.getVariableTypes());
                    } else {
                        for (Object type : variable.getVariableTypes()) {
                            existingVariable.addVariableType(type);
                        }
                    }
                }
            } else {
                this.variables.put(variable.getName(), variable);
            }
        }

        public VariableInfo getVariable(String name) {
            return this.getVariable(name, new HashSet<String>());
        }

        public VariableInfo getVariable(String name, Set<String> importsFromGlobal) {
            return this.innerGetVariable(name, new HashSet<String>(importsFromGlobal));
        }

        private VariableInfo innerGetVariable(String name, Set<String> importsFromGlobal) {
            VariableInfo info;
            if (this.globalImports != null && !this.globalImports.isEmpty()) {
                importsFromGlobal.addAll(this.globalImports);
            }
            if ((info = this.variables.get(name)) != null) {
                return info;
            }
            if (this.parent != null) {
                if (this.parent.isGlobalScope()) {
                    if (importsFromGlobal.contains(name) || !(this.root instanceof FunctionDeclaration) && !(this.root instanceof ClassDeclaration)) {
                        return this.parent.getVariable(name, importsFromGlobal);
                    }
                } else {
                    return this.parent.getVariable(name, importsFromGlobal);
                }
            }
            return null;
        }

        public IElementEntry getEntry() {
            return this.entry;
        }

        public ASTNode getRoot() {
            return this.root;
        }

        public Scope getParent() {
            return this.parent;
        }

        public Set<VariableInfo> getVariables() {
            return this.getVariables(new HashSet<String>());
        }

        private Set<VariableInfo> getVariables(Set<String> importsFromGlobal) {
            if (this.globalImports != null && !this.globalImports.isEmpty()) {
                importsFromGlobal.addAll(this.globalImports);
            }
            HashSet<VariableInfo> result = new HashSet<VariableInfo>();
            for (VariableInfo variable : this.variables.values()) {
                result.add(variable);
            }
            if (this.parent != null) {
                if (!this.parent.isGlobalScope()) {
                    result.addAll(this.parent.getVariables(importsFromGlobal));
                } else if (this.automaticallyDeriveGlobalVariables()) {
                    result.addAll(this.parent.getVariables(new HashSet<String>()));
                } else {
                    for (String var : importsFromGlobal) {
                        VariableInfo varInfo = this.parent.getVariable(var, importsFromGlobal);
                        if (varInfo == null) continue;
                        result.add(varInfo);
                    }
                }
            }
            return result;
        }

        private boolean automaticallyDeriveGlobalVariables() {
            if (!this.parent.isGlobalScope()) {
                return false;
            }
            return !(this.getRoot() instanceof TypeDeclaration) && !(this.getRoot() instanceof FunctionDeclaration) && !(this.getRoot() instanceof MethodDeclaration) && !(this.root instanceof LambdaFunctionDeclaration);
        }
    }

    private class VariableInfo {
        private String variableName;
        private Set<Object> variableTypes;
        private Scope scope;
        private int nodeStart = 0;
        private int modifier = 0;

        private VariableInfo(String variableName, Object variableType, Scope scope, int pos) {
            this.variableName = variableName;
            this.variableTypes = new HashSet<Object>(1);
            if (variableType != null) {
                this.variableTypes.add(variableType);
            }
            this.scope = scope;
            this.nodeStart = pos;
            this.grabDockedTypes();
        }

        private VariableInfo(String variableName, Set<Object> variableTypes, Scope scope, int pos) {
            this.variableName = variableName;
            this.variableTypes = variableTypes;
            this.scope = scope;
            this.nodeStart = pos;
            this.grabDockedTypes();
        }

        private VariableInfo(String variableName, Set<Object> variableTypes, Scope scope, int pos, int modifier) {
            this.variableName = variableName;
            this.variableTypes = variableTypes;
            this.scope = scope;
            this.nodeStart = pos;
            this.modifier = modifier;
            this.grabDockedTypes();
        }

        public Set<Object> getVariableTypes() {
            if (this.variableTypes != null) {
                return this.variableTypes;
            }
            return Collections.emptySet();
        }

        public void setVariableType(Object variableType) {
            this.variableTypes = new HashSet<Object>(1);
            this.variableTypes.add(variableType);
        }

        public void setVariableTypes(Collection<Object> variableType) {
            this.variableTypes = new HashSet<Object>();
            this.variableTypes.addAll(variableType);
        }

        public void addVariableType(Object variableType) {
            if (this.variableTypes == null) {
                this.variableTypes = new HashSet<Object>();
            }
            this.variableTypes.add(variableType);
        }

        public String getName() {
            return this.variableName;
        }

        public Scope getScope() {
            return this.scope;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.variableName);
            buffer.append(" types:");
            buffer.append(this.variableTypes.toString());
            return buffer.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.variableName == null ? 0 : this.variableName.hashCode());
            return result;
        }

        public int getNodeStart() {
            return this.nodeStart;
        }

        public int getModifier() {
            return this.modifier;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableInfo other = (VariableInfo)obj;
            return !(this.variableName == null ? other.variableName != null : !this.variableName.equals(other.variableName));
        }

        private void grabDockedTypes() {
            List<TypedDescription> vars;
            FunctionDocumentation documentation;
            PHPDocBlock comment = PHPDocUtils.findPHPDocComment(PDTPHPModuleIndexer.this._comments, this.nodeStart, PDTPHPModuleIndexer.this._contents);
            if (comment != null && (documentation = PHPDocUtils.getFunctionDocumentation((IPHPDoc)comment)) != null && (vars = documentation.getVars()) != null && vars.size() != 0) {
                if (this.variableTypes == null) {
                    this.variableTypes = new HashSet<Object>();
                }
                for (TypedDescription descr : vars) {
                    String[] types;
                    String[] stringArray = types = descr.getTypes();
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String type = stringArray[n2];
                        this.variableTypes.add(type);
                        ++n2;
                    }
                }
            }
        }
    }
}

